-- File is ROM program for loop nesting test
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- =======================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =======================================================
ENTITY rom4096x32 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(0 TO 11); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(0 TO 31)); -- Program memory data
END ENTITY rom4096x32;
-- =======================================================
ARCHITECTURE fpga OF rom4096x32 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(0 TO 31);
CONSTANT prom : MEMP := (
X"b0000000",  --  0:	imm	0
X"b81804b4",  --  4:	braid	4b4
--X"b87c04b4",  --  4:	bralid	r3, 4b4
X"302018CC",  --  4/8:	addik	r1, r0, 6348 Delay slot?
--X"b80804b4",  --  8:	brai	4b4
--X"b84c04b4",  --  8:	brali	r2, 4b4
--=============ca. 230 NOPs ===============================
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
--50
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
--100
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
--150
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
--200
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",X"80000000",X"80000000",X"80000000",X"80000000",
X"80000000",
--231
--========================================================
--void level3(int *array, int s1) {
X"3021fff8",  -- 3a8:	 	addik	r1, r1, -8
X"fa610004",  -- 3ac:	 	swi	r19, r1, 4
X"12610000",  -- 3b0:	 	addk	r19, r1, r0
X"f8b3000c",  -- 3b4:	 	swi	r5, r19, 12
X"f8d30010",  -- 3b8:	 	swi	r6, r19, 16
--    s1 += 1;
X"e8730010",  -- 3bc:	 	lwi	r3, r19, 16
X"30630001",  -- 3c0:	 	addik	r3, r3, 1
X"f8730010",  -- 3c4:	 	swi	r3, r19, 16
--    array[3] = s1;
X"e873000c",  -- 3c8:	 	lwi	r3, r19, 12
X"3063000c",  -- 3cc:	 	addik	r3, r3, 12
X"e8930010",  -- 3d0:	 	lwi	r4, r19, 16
X"f8830000",  -- 3d4:	 	swi	r4, r3, 0
--    return;
X"80000000",  -- 3d8:	 	or	r0, r0, r0
--}
X"10330000",  -- 3dc:	 	addk	r1, r19, r0
X"ea610004",  -- 3e0:	 	lwi	r19, r1, 4
X"30210008",  -- 3e4:	 	addik	r1, r1, 8
X"b60f0008",  -- 3e8:	 	rtsd	r15, 8
X"80000000",  -- 3ec:	 	or	r0, r0, r0
--==============================================
--void level2(int *array, int s1) {
X"3021ffe0",  -- 3f0:	 	addik	r1, r1, -32
X"f9e10000",  -- 3f4:	 	swi	r15, r1, 0
X"fa61001c",  -- 3f8:	 	swi	r19, r1, 28
X"12610000",  -- 3fc:	 	addk	r19, r1, r0
X"f8b30024",  -- 400:	 	swi	r5, r19, 36
X"f8d30028",  -- 404:	 	swi	r6, r19, 40
--    s1 += s1;
X"e8930028",  -- 408:	 	lwi	r4, r19, 40
X"e8730028",  -- 40c:	 	lwi	r3, r19, 40
X"10641800",  -- 410:	 	addk	r3, r4, r3
X"f8730028",  -- 414:	 	swi	r3, r19, 40
--    array[2] = s1;
X"e8730024",  -- 418:	 	lwi	r3, r19, 36
X"30630008",  -- 41c:	 	addik	r3, r3, 8
X"e8930028",  -- 420:	 	lwi	r4, r19, 40
X"f8830000",  -- 424:	 	swi	r4, r3, 0
--    level3(array, s1); // call level 3
X"e8d30028",  -- 428:	 	lwi	r6, r19, 40
X"e8b30024",  -- 42c:	 	lwi	r5, r19, 36
X"b9f4ff78",  -- 430:	 	brlid	r15, -136	// 3a8 <level3>
X"80000000",  -- 434:	 	or	r0, r0, r0
--    return;
X"80000000",  -- 438:	 	or	r0, r0, r0
--}
X"e9e10000",  -- 43c:	 	lwi	r15, r1, 0
X"10330000",  -- 440:	 	addk	r1, r19, r0
X"ea61001c",  -- 444:	 	lwi	r19, r1, 28
X"30210020",  -- 448:	 	addik	r1, r1, 32
X"b60f0008",  -- 44c:	 	rtsd	r15, 8
X"80000000",  -- 450:	 	or	r0, r0, r0
-- void level1(int *array, int s1) {
X"3021ffe0",  -- 454:	 	addik	r1, r1, -32
X"f9e10000",  -- 458:	 	swi	r15, r1, 0
X"fa61001c",  -- 45c:	 	swi	r19, r1, 28
X"12610000",  -- 460:	 	addk	r19, r1, r0
X"f8b30024",  -- 464:	 	swi	r5, r19, 36
X"f8d30028",  -- 468:	 	swi	r6, r19, 40
--    s1 += 1;
X"e8730028",  -- 46c:	 	lwi	r3, r19, 40
X"30630001",  -- 470:	 	addik	r3, r3, 1
X"f8730028",  -- 474:	 	swi	r3, r19, 40
--    array[1] = s1;
X"e8730024",  -- 478:	 	lwi	r3, r19, 36
X"30630004",  -- 47c:	 	addik	r3, r3, 4
X"e8930028",  -- 480:	 	lwi	r4, r19, 40
X"f8830000",  -- 484:	 	swi	r4, r3, 0
--    level2(array, s1); // call level 2
X"e8d30028",  -- 488:	 	lwi	r6, r19, 40
X"e8b30024",  -- 48c:	 	lwi	r5, r19, 36
X"b9f4ff60",  -- 490:	 	brlid	r15, -160	// 3f0 <level2>
X"80000000",  -- 494:	 	or	r0, r0, r0
--    return;
X"80000000",  -- 498:	 	or	r0, r0, r0
-- }
X"e9e10000",  -- 49c:	 	lwi	r15, r1, 0
X"10330000",  -- 4a0:	 	addk	r1, r19, r0
X"ea61001c",  -- 4a4:	 	lwi	r19, r1, 28
X"30210020",  -- 4a8:	 	addik	r1, r1, 32
X"b60f0008",  -- 4ac:	 	rtsd	r15, 8
X"80000000",  -- 4b0:	 	or	r0, r0, r0
--int main(void) {
X"3021ffa8",  -- 4b4:		addik	r1, r1, -88
X"f9e10000",  -- 4b8:	 	swi	r15, r1, 0
X"fa610054",  -- 4bc:	 	swi	r19, r1, 84
X"12610000",  -- 4c0:	 	addk	r19, r1, r0
--  volatile int s1, s2, s3;
--  int array[11];
--  s1 = 0x1233; // Memory location sp+0
X"30601233",  -- 4c4:	 	addik	r3, r0, 4659
X"f873001c",  -- 4c8:	 	swi	r3, r19, 28
--  while(1)  {
--    level1(array, s1);
X"e893001c",  -- 4cc:	 	lwi	r4, r19, 28
X"30730028",  -- 4d0:	 	addik	r3, r19, 40
X"10c40000",  -- 4d4:	 	addk	r6, r4, r0
X"10a30000",  -- 4d8:	 	addk	r5, r3, r0
X"b9f4ff78",  -- 4dc:	 	brlid	r15, -136	// 454 <level1>
X"80000000",  -- 4e0:	 	or	r0, r0, r0
--    s1 = array[1];
X"e873002c",  -- 4e4:	 	lwi	r3, r19, 44
X"f873001c",  -- 4e8:	 	swi	r3, r19, 28
--    s2 = array[2];
X"e8730030",  -- 4ec:	 	lwi	r3, r19, 48
X"f8730020",  -- 4f0:	 	swi	r3, r19, 32
--    s3 = array[3];
X"e8730034",  -- 4f4:	 	lwi	r3, r19, 52
X"f8730024",  -- 4f8:	 	swi	r3, r19, 36
--  }
X"b800ffd0",  -- 4fc:	 	bri	-48		// 4cc
--OTHERS => X"80000000"); -- default NOP
OTHERS => "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"); -- Default unknown mem

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
